unit WinForm;

interface

uses
  System.Drawing,
  System.Collections,
  System.ComponentModel,
  System.Windows.Forms,
  System.Data,
  Borland.Eco.Services,
  Borland.Eco.UmlRt,
  Borland.Eco.ObjectRepresentation,
  Borland.Eco.WinForm,
  Borland.Eco.Handles,
  ServiceDemoEcoSpace,
  CoreClassesUnit;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    btnUpdatedatabase: System.Windows.Forms.Button;
    lbxClasses: System.Windows.Forms.ListBox;
    btnGetClasses: System.Windows.Forms.Button;
    ReferenceHandle1: Borland.Eco.Handles.ReferenceHandle;
    ExpressionHandle1: Borland.Eco.Handles.ExpressionHandle;
    lbxInstances: System.Windows.Forms.ListBox;
    btnUsingConstructor: System.Windows.Forms.Button;
    EcoActionExtender1: Borland.Eco.WinForm.EcoActionExtender;
    HelpProvider1: System.Windows.Forms.HelpProvider;
    btnCreateByClassName: System.Windows.Forms.Button;
    btnCreateByClassType: System.Windows.Forms.Button;
    btnCreateByIClass: System.Windows.Forms.Button;
    EcoAutoFormExtender1: Borland.Eco.WinForm.EcoAutoFormExtender;
    lblInstances: System.Windows.Forms.Label;
    lbxProperties: System.Windows.Forms.ListBox;
    GroupBox1: System.Windows.Forms.GroupBox;
    GroupBox2: System.Windows.Forms.GroupBox;
    btnGetProperties: System.Windows.Forms.Button;
    btnExtractValue: System.Windows.Forms.Button;
    GroupBox3: System.Windows.Forms.GroupBox;
    Label1: System.Windows.Forms.Label;
    TextBox1: System.Windows.Forms.TextBox;
    tbxPropertyData: System.Windows.Forms.TextBox;
    GroupBox4: System.Windows.Forms.GroupBox;
    btnSetViaPerson: System.Windows.Forms.Button;
    btnSetAsObject: System.Windows.Forms.Button;
    btnSetViaAssign: System.Windows.Forms.Button;
    btnUnloadObject: System.Windows.Forms.Button;
    GroupBox5: System.Windows.Forms.GroupBox;
    btnUnloadList: System.Windows.Forms.Button;
    GroupBox6: System.Windows.Forms.GroupBox;
    btnUndo: System.Windows.Forms.Button;
    btnRedo: System.Windows.Forms.Button;
    btnSetUndoPoint: System.Windows.Forms.Button;
    btnCLearBlocks: System.Windows.Forms.Button;
    btnTransactions: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents ofecospace this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
    procedure btnGetClasses_Click(sender: System.Object; e: System.EventArgs);
    procedure btnCreateByClassName_Click(sender: System.Object; e: System.EventArgs);
    procedure btnUsingConstructor_Click(sender: System.Object; e: System.EventArgs);
    procedure btnCreateByClassType_Click(sender: System.Object; e: System.EventArgs);
    procedure btnCreateByIClass_Click(sender: System.Object; e: System.EventArgs);
    procedure lbxInstances_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
    procedure btnGetProperties_Click(sender: System.Object; e: System.EventArgs);
    procedure btnExtractValue_Click(sender: System.Object; e: System.EventArgs);
    procedure btnSetViaPerson_Click(sender: System.Object; e: System.EventArgs);
    procedure btnSetAsObject_Click(sender: System.Object; e: System.EventArgs);
    procedure btnSetViaAssign_Click(sender: System.Object; e: System.EventArgs);
    procedure btnUnloadObject_Click(sender: System.Object; e: System.EventArgs);
    procedure btnUnloadList_Click(sender: System.Object; e: System.EventArgs);
    procedure btnUndo_Click(sender: System.Object; e: System.EventArgs);
    procedure btnRedo_Click(sender: System.Object; e: System.EventArgs);
    procedure btnSetUndoPoint_Click(sender: System.Object; e: System.EventArgs);
    procedure btnCLearBlocks_Click(sender: System.Object; e: System.EventArgs);
    procedure btnTransactions_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    FEcoSpace: TServiceDemoEcoSpace;
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  public
    constructor Create;
    property EcoSpace: TServiceDemoEcoSpace read FEcoSpace;
  end;

implementation
{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
type
  TArrayOfBorland_Eco_Handles_AbstractColumn = array of Borland.Eco.Handles.AbstractColumn;
var
  Column11: Borland.Eco.Handles.Column;
begin
  Column11 := Borland.Eco.Handles.Column.Create;
  Self.btnUpdatedatabase := System.Windows.Forms.Button.Create;
  Self.lbxClasses := System.Windows.Forms.ListBox.Create;
  Self.btnGetClasses := System.Windows.Forms.Button.Create;
  Self.ReferenceHandle1 := Borland.Eco.Handles.ReferenceHandle.Create;
  Self.ExpressionHandle1 := Borland.Eco.Handles.ExpressionHandle.Create;
  Self.lbxInstances := System.Windows.Forms.ListBox.Create;
  Self.btnUsingConstructor := System.Windows.Forms.Button.Create;
  Self.EcoActionExtender1 := Borland.Eco.WinForm.EcoActionExtender.Create;
  Self.HelpProvider1 := System.Windows.Forms.HelpProvider.Create;
  Self.btnCreateByClassName := System.Windows.Forms.Button.Create;
  Self.btnCreateByClassType := System.Windows.Forms.Button.Create;
  Self.btnCreateByIClass := System.Windows.Forms.Button.Create;
  Self.btnUnloadObject := System.Windows.Forms.Button.Create;
  Self.EcoAutoFormExtender1 := Borland.Eco.WinForm.EcoAutoFormExtender.Create;
  Self.lblInstances := System.Windows.Forms.Label.Create;
  Self.lbxProperties := System.Windows.Forms.ListBox.Create;
  Self.GroupBox1 := System.Windows.Forms.GroupBox.Create;
  Self.GroupBox2 := System.Windows.Forms.GroupBox.Create;
  Self.btnGetProperties := System.Windows.Forms.Button.Create;
  Self.btnExtractValue := System.Windows.Forms.Button.Create;
  Self.GroupBox3 := System.Windows.Forms.GroupBox.Create;
  Self.TextBox1 := System.Windows.Forms.TextBox.Create;
  Self.Label1 := System.Windows.Forms.Label.Create;
  Self.tbxPropertyData := System.Windows.Forms.TextBox.Create;
  Self.GroupBox4 := System.Windows.Forms.GroupBox.Create;
  Self.btnSetViaAssign := System.Windows.Forms.Button.Create;
  Self.btnSetAsObject := System.Windows.Forms.Button.Create;
  Self.btnSetViaPerson := System.Windows.Forms.Button.Create;
  Self.GroupBox5 := System.Windows.Forms.GroupBox.Create;
  Self.btnUnloadList := System.Windows.Forms.Button.Create;
  Self.GroupBox6 := System.Windows.Forms.GroupBox.Create;
  Self.btnTransactions := System.Windows.Forms.Button.Create;
  Self.btnCLearBlocks := System.Windows.Forms.Button.Create;
  Self.btnSetUndoPoint := System.Windows.Forms.Button.Create;
  Self.btnRedo := System.Windows.Forms.Button.Create;
  Self.btnUndo := System.Windows.Forms.Button.Create;
  Self.GroupBox1.SuspendLayout;
  Self.GroupBox2.SuspendLayout;
  Self.GroupBox3.SuspendLayout;
  Self.GroupBox4.SuspendLayout;
  Self.GroupBox5.SuspendLayout;
  Self.GroupBox6.SuspendLayout;
  Self.SuspendLayout;
  // 
  // btnUpdatedatabase
  // 
  Self.btnUpdatedatabase.Location := System.Drawing.Point.Create(8, 56);
  Self.btnUpdatedatabase.Name := 'btnUpdatedatabase';
  Self.btnUpdatedatabase.Size := System.Drawing.Size.Create(216, 23);
  Self.btnUpdatedatabase.TabIndex := 0;
  Self.btnUpdatedatabase.Text := 'Update database';
  Include(Self.btnUpdatedatabase.Click, Self.Button1_Click);
  // 
  // lbxClasses
  // 
  Self.lbxClasses.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.lbxClasses.Location := System.Drawing.Point.Create(8, 16);
  Self.lbxClasses.Name := 'lbxClasses';
  Self.lbxClasses.Size := System.Drawing.Size.Create(208, 212);
  Self.lbxClasses.TabIndex := 1;
  Include(Self.lbxClasses.DoubleClick, Self.btnCreateByClassName_Click);
  // 
  // btnGetClasses
  // 
  Self.HelpProvider1.SetHelpString(Self.btnGetClasses, 'Get a list of all mo' +
    'deled classes in system');
  Self.btnGetClasses.Location := System.Drawing.Point.Create(8, 24);
  Self.btnGetClasses.Name := 'btnGetClasses';
  Self.HelpProvider1.SetShowHelp(Self.btnGetClasses, True);
  Self.btnGetClasses.Size := System.Drawing.Size.Create(184, 23);
  Self.btnGetClasses.TabIndex := 2;
  Self.btnGetClasses.Text := 'Get classes ->';
  Include(Self.btnGetClasses.Click, Self.btnGetClasses_Click);
  // 
  // ReferenceHandle1
  // 
  Self.ReferenceHandle1.EcoSpaceType := TypeOf(ServiceDemoEcoSpace.TServiceDemoEcoSpace);
  // 
  // ExpressionHandle1
  // 
  Column11.Expression := 'self.name';
  Column11.Name := 'New1';
  Self.ExpressionHandle1.Columns.AddRange(TArrayOfBorland_Eco_Handles_AbstractColumn.Create(Column11));
  Self.ExpressionHandle1.Expression := 'Person.allInstances';
  Self.ExpressionHandle1.RootHandle := Self.ReferenceHandle1;
  // 
  // lbxInstances
  // 
  Self.lbxInstances.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.lbxInstances.DataSource := Self.ExpressionHandle1;
  Self.lbxInstances.DisplayMember := 'name';
  Self.EcoAutoFormExtender1.SetEcoAutoForm(Self.lbxInstances, True);
  Self.lbxInstances.Location := System.Drawing.Point.Create(8, 32);
  Self.lbxInstances.Name := 'lbxInstances';
  Self.lbxInstances.Size := System.Drawing.Size.Create(224, 134);
  Self.lbxInstances.TabIndex := 4;
  Include(Self.lbxInstances.SelectedIndexChanged, Self.lbxInstances_SelectedIndexChanged);
  // 
  // btnUsingConstructor
  // 
  Self.btnUsingConstructor.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.HelpProvider1.SetHelpString(Self.btnUsingConstructor, '');
  Self.btnUsingConstructor.Location := System.Drawing.Point.Create(8, 232);
  Self.btnUsingConstructor.Name := 'btnUsingConstructor';
  Self.HelpProvider1.SetShowHelp(Self.btnUsingConstructor, True);
  Self.btnUsingConstructor.Size := System.Drawing.Size.Create(208, 23);
  Self.btnUsingConstructor.TabIndex := 5;
  Self.btnUsingConstructor.Text := 'Create using constructor';
  Include(Self.btnUsingConstructor.Click, Self.btnUsingConstructor_Click);
  // 
  // EcoActionExtender1
  // 
  Self.EcoActionExtender1.CaptionToggleActive := 'Deactivate';
  // 
  // btnCreateByClassName
  // 
  Self.btnCreateByClassName.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.HelpProvider1.SetHelpString(Self.btnCreateByClassName, '');
  Self.btnCreateByClassName.Location := System.Drawing.Point.Create(8, 264);
  Self.btnCreateByClassName.Name := 'btnCreateByClassName';
  Self.HelpProvider1.SetShowHelp(Self.btnCreateByClassName, True);
  Self.btnCreateByClassName.Size := System.Drawing.Size.Create(208, 23);
  Self.btnCreateByClassName.TabIndex := 7;
  Self.btnCreateByClassName.Text := 'Create by class name';
  Include(Self.btnCreateByClassName.Click, Self.btnCreateByClassName_Click);
  // 
  // btnCreateByClassType
  // 
  Self.btnCreateByClassType.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.HelpProvider1.SetHelpString(Self.btnCreateByClassType, '');
  Self.btnCreateByClassType.Location := System.Drawing.Point.Create(8, 296);
  Self.btnCreateByClassType.Name := 'btnCreateByClassType';
  Self.HelpProvider1.SetShowHelp(Self.btnCreateByClassType, True);
  Self.btnCreateByClassType.Size := System.Drawing.Size.Create(208, 23);
  Self.btnCreateByClassType.TabIndex := 8;
  Self.btnCreateByClassType.Text := 'Create by class type';
  Include(Self.btnCreateByClassType.Click, Self.btnCreateByClassType_Click);
  // 
  // btnCreateByIClass
  // 
  Self.btnCreateByIClass.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.HelpProvider1.SetHelpString(Self.btnCreateByIClass, '');
  Self.btnCreateByIClass.Location := System.Drawing.Point.Create(8, 328);
  Self.btnCreateByIClass.Name := 'btnCreateByIClass';
  Self.HelpProvider1.SetShowHelp(Self.btnCreateByIClass, True);
  Self.btnCreateByIClass.Size := System.Drawing.Size.Create(208, 23);
  Self.btnCreateByIClass.TabIndex := 9;
  Self.btnCreateByIClass.Text := 'Create by IClass';
  Include(Self.btnCreateByIClass.Click, Self.btnCreateByIClass_Click);
  // 
  // btnUnloadObject
  // 
  Self.HelpProvider1.SetHelpString(Self.btnUnloadObject, 'Unload selected ob' +
    'ject');
  Self.btnUnloadObject.Location := System.Drawing.Point.Create(8, 24);
  Self.btnUnloadObject.Name := 'btnUnloadObject';
  Self.HelpProvider1.SetShowHelp(Self.btnUnloadObject, True);
  Self.btnUnloadObject.TabIndex := 10;
  Self.btnUnloadObject.Text := 'Unload';
  Include(Self.btnUnloadObject.Click, Self.btnUnloadObject_Click);
  // 
  // lblInstances
  // 
  Self.lblInstances.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.lblInstances.Location := System.Drawing.Point.Create(8, 16);
  Self.lblInstances.Name := 'lblInstances';
  Self.lblInstances.Size := System.Drawing.Size.Create(216, 16);
  Self.lblInstances.TabIndex := 10;
  Self.lblInstances.Text := 'Instance list (Person.allInstances)';
  // 
  // lbxProperties
  // 
  Self.lbxProperties.Location := System.Drawing.Point.Create(8, 88);
  Self.lbxProperties.Name := 'lbxProperties';
  Self.lbxProperties.Size := System.Drawing.Size.Create(184, 56);
  Self.lbxProperties.TabIndex := 11;
  // 
  // GroupBox1
  // 
  Self.GroupBox1.Controls.Add(Self.lbxClasses);
  Self.GroupBox1.Controls.Add(Self.btnCreateByClassName);
  Self.GroupBox1.Controls.Add(Self.btnCreateByClassType);
  Self.GroupBox1.Controls.Add(Self.btnCreateByIClass);
  Self.GroupBox1.Controls.Add(Self.btnUsingConstructor);
  Self.GroupBox1.Location := System.Drawing.Point.Create(216, 0);
  Self.GroupBox1.Name := 'GroupBox1';
  Self.GroupBox1.Size := System.Drawing.Size.Create(224, 360);
  Self.GroupBox1.TabIndex := 12;
  Self.GroupBox1.TabStop := False;
  Self.GroupBox1.Text := 'IFactoryService';
  // 
  // GroupBox2
  // 
  Self.GroupBox2.Controls.Add(Self.btnGetProperties);
  Self.GroupBox2.Controls.Add(Self.btnGetClasses);
  Self.GroupBox2.Controls.Add(Self.lbxProperties);
  Self.GroupBox2.Location := System.Drawing.Point.Create(8, 0);
  Self.GroupBox2.Name := 'GroupBox2';
  Self.GroupBox2.Size := System.Drawing.Size.Create(200, 152);
  Self.GroupBox2.TabIndex := 13;
  Self.GroupBox2.TabStop := False;
  Self.GroupBox2.Text := 'ITypeSystemService + meta access';
  // 
  // btnGetProperties
  // 
  Self.btnGetProperties.Location := System.Drawing.Point.Create(8, 56);
  Self.btnGetProperties.Name := 'btnGetProperties';
  Self.btnGetProperties.Size := System.Drawing.Size.Create(184, 23);
  Self.btnGetProperties.TabIndex := 3;
  Self.btnGetProperties.Text := 'Get Properties v ';
  Include(Self.btnGetProperties.Click, Self.btnGetProperties_Click);
  // 
  // btnExtractValue
  // 
  Self.btnExtractValue.Location := System.Drawing.Point.Create(16, 24);
  Self.btnExtractValue.Name := 'btnExtractValue';
  Self.btnExtractValue.Size := System.Drawing.Size.Create(176, 23);
  Self.btnExtractValue.TabIndex := 14;
  Self.btnExtractValue.Text := 'Extract property value';
  Include(Self.btnExtractValue.Click, Self.btnExtractValue_Click);
  // 
  // GroupBox3
  // 
  Self.GroupBox3.Controls.Add(Self.TextBox1);
  Self.GroupBox3.Controls.Add(Self.Label1);
  Self.GroupBox3.Controls.Add(Self.lblInstances);
  Self.GroupBox3.Controls.Add(Self.lbxInstances);
  Self.GroupBox3.Location := System.Drawing.Point.Create(448, 0);
  Self.GroupBox3.Name := 'GroupBox3';
  Self.GroupBox3.Size := System.Drawing.Size.Create(240, 224);
  Self.GroupBox3.TabIndex := 15;
  Self.GroupBox3.TabStop := False;
  Self.GroupBox3.Text := 'Databinding (Person)';
  // 
  // TextBox1
  // 
  Self.TextBox1.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.TextBox1.DataBindings.Add(System.Windows.Forms.Binding.Create('Text', 
        Self.ExpressionHandle1, 'name'));
  Self.TextBox1.Location := System.Drawing.Point.Create(8, 192);
  Self.TextBox1.Name := 'TextBox1';
  Self.TextBox1.Size := System.Drawing.Size.Create(224, 20);
  Self.TextBox1.TabIndex := 12;
  Self.TextBox1.Text := 'TextBox1';
  // 
  // Label1
  // 
  Self.Label1.Anchor := (System.Windows.Forms.AnchorStyles(((System.Windows.Forms.AnchorStyles.Bottom 
    or System.Windows.Forms.AnchorStyles.Left) or System.Windows.Forms.AnchorStyles.Right)));
  Self.Label1.Location := System.Drawing.Point.Create(8, 176);
  Self.Label1.Name := 'Label1';
  Self.Label1.Size := System.Drawing.Size.Create(140, 16);
  Self.Label1.TabIndex := 11;
  Self.Label1.Text := 'Name';
  // 
  // tbxPropertyData
  // 
  Self.tbxPropertyData.Location := System.Drawing.Point.Create(16, 56);
  Self.tbxPropertyData.Name := 'tbxPropertyData';
  Self.tbxPropertyData.Size := System.Drawing.Size.Create(168, 20);
  Self.tbxPropertyData.TabIndex := 16;
  Self.tbxPropertyData.Text := '';
  // 
  // GroupBox4
  // 
  Self.GroupBox4.Controls.Add(Self.btnSetViaAssign);
  Self.GroupBox4.Controls.Add(Self.btnSetAsObject);
  Self.GroupBox4.Controls.Add(Self.btnSetViaPerson);
  Self.GroupBox4.Controls.Add(Self.btnExtractValue);
  Self.GroupBox4.Controls.Add(Self.tbxPropertyData);
  Self.GroupBox4.Location := System.Drawing.Point.Create(8, 160);
  Self.GroupBox4.Name := 'GroupBox4';
  Self.GroupBox4.Size := System.Drawing.Size.Create(200, 200);
  Self.GroupBox4.TabIndex := 17;
  Self.GroupBox4.TabStop := False;
  Self.GroupBox4.Text := 'Generic property access';
  // 
  // btnSetViaAssign
  // 
  Self.btnSetViaAssign.Location := System.Drawing.Point.Create(24, 160);
  Self.btnSetViaAssign.Name := 'btnSetViaAssign';
  Self.btnSetViaAssign.Size := System.Drawing.Size.Create(160, 23);
  Self.btnSetViaAssign.TabIndex := 19;
  Self.btnSetViaAssign.Text := 'Set via Assign';
  Include(Self.btnSetViaAssign.Click, Self.btnSetViaAssign_Click);
  // 
  // btnSetAsObject
  // 
  Self.btnSetAsObject.Location := System.Drawing.Point.Create(24, 128);
  Self.btnSetAsObject.Name := 'btnSetAsObject';
  Self.btnSetAsObject.Size := System.Drawing.Size.Create(160, 23);
  Self.btnSetAsObject.TabIndex := 18;
  Self.btnSetAsObject.Text := 'Set via AsObject';
  Include(Self.btnSetAsObject.Click, Self.btnSetAsObject_Click);
  // 
  // btnSetViaPerson
  // 
  Self.btnSetViaPerson.Location := System.Drawing.Point.Create(24, 96);
  Self.btnSetViaPerson.Name := 'btnSetViaPerson';
  Self.btnSetViaPerson.Size := System.Drawing.Size.Create(160, 23);
  Self.btnSetViaPerson.TabIndex := 17;
  Self.btnSetViaPerson.Text := 'Set via Person';
  Include(Self.btnSetViaPerson.Click, Self.btnSetViaPerson_Click);
  // 
  // GroupBox5
  // 
  Self.GroupBox5.Controls.Add(Self.btnUnloadList);
  Self.GroupBox5.Controls.Add(Self.btnUnloadObject);
  Self.GroupBox5.Controls.Add(Self.btnUpdatedatabase);
  Self.GroupBox5.Location := System.Drawing.Point.Create(448, 360);
  Self.GroupBox5.Name := 'GroupBox5';
  Self.GroupBox5.Size := System.Drawing.Size.Create(240, 88);
  Self.GroupBox5.TabIndex := 18;
  Self.GroupBox5.TabStop := False;
  Self.GroupBox5.Text := 'IPersistenceService';
  // 
  // btnUnloadList
  // 
  Self.btnUnloadList.Location := System.Drawing.Point.Create(149, 24);
  Self.btnUnloadList.Name := 'btnUnloadList';
  Self.btnUnloadList.TabIndex := 11;
  Self.btnUnloadList.Text := 'Unload list';
  Include(Self.btnUnloadList.Click, Self.btnUnloadList_Click);
  // 
  // GroupBox6
  // 
  Self.GroupBox6.Controls.Add(Self.btnTransactions);
  Self.GroupBox6.Controls.Add(Self.btnCLearBlocks);
  Self.GroupBox6.Controls.Add(Self.btnSetUndoPoint);
  Self.GroupBox6.Controls.Add(Self.btnRedo);
  Self.GroupBox6.Controls.Add(Self.btnUndo);
  Self.GroupBox6.Location := System.Drawing.Point.Create(448, 232);
  Self.GroupBox6.Name := 'GroupBox6';
  Self.GroupBox6.Size := System.Drawing.Size.Create(240, 120);
  Self.GroupBox6.TabIndex := 19;
  Self.GroupBox6.TabStop := False;
  Self.GroupBox6.Text := 'IUndoService';
  // 
  // btnTransactions
  // 
  Self.btnTransactions.Location := System.Drawing.Point.Create(120, 56);
  Self.btnTransactions.Name := 'btnTransactions';
  Self.btnTransactions.Size := System.Drawing.Size.Create(112, 23);
  Self.btnTransactions.TabIndex := 4;
  Self.btnTransactions.Text := 'Undo-transactions';
  Include(Self.btnTransactions.Click, Self.btnTransactions_Click);
  // 
  // btnCLearBlocks
  // 
  Self.btnCLearBlocks.Location := System.Drawing.Point.Create(120, 24);
  Self.btnCLearBlocks.Name := 'btnCLearBlocks';
  Self.btnCLearBlocks.Size := System.Drawing.Size.Create(112, 23);
  Self.btnCLearBlocks.TabIndex := 3;
  Self.btnCLearBlocks.Text := 'Clear Undo-blocks';
  Include(Self.btnCLearBlocks.Click, Self.btnCLearBlocks_Click);
  // 
  // btnSetUndoPoint
  // 
  Self.btnSetUndoPoint.Location := System.Drawing.Point.Create(8, 88);
  Self.btnSetUndoPoint.Name := 'btnSetUndoPoint';
  Self.btnSetUndoPoint.Size := System.Drawing.Size.Create(104, 23);
  Self.btnSetUndoPoint.TabIndex := 2;
  Self.btnSetUndoPoint.Text := 'Set Undo-point';
  Include(Self.btnSetUndoPoint.Click, Self.btnSetUndoPoint_Click);
  // 
  // btnRedo
  // 
  Self.btnRedo.Location := System.Drawing.Point.Create(8, 56);
  Self.btnRedo.Name := 'btnRedo';
  Self.btnRedo.Size := System.Drawing.Size.Create(104, 23);
  Self.btnRedo.TabIndex := 1;
  Self.btnRedo.Text := 'Redo';
  Include(Self.btnRedo.Click, Self.btnRedo_Click);
  // 
  // btnUndo
  // 
  Self.btnUndo.Location := System.Drawing.Point.Create(8, 24);
  Self.btnUndo.Name := 'btnUndo';
  Self.btnUndo.Size := System.Drawing.Size.Create(104, 23);
  Self.btnUndo.TabIndex := 0;
  Self.btnUndo.Text := 'Undo';
  Include(Self.btnUndo.Click, Self.btnUndo_Click);
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(696, 454);
  Self.Controls.Add(Self.GroupBox6);
  Self.Controls.Add(Self.GroupBox5);
  Self.Controls.Add(Self.GroupBox2);
  Self.Controls.Add(Self.GroupBox1);
  Self.Controls.Add(Self.GroupBox4);
  Self.Controls.Add(Self.GroupBox3);
  Self.Name := 'TWinForm';
  Self.HelpProvider1.SetShowHelp(Self, True);
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterScreen;
  Self.Text := 'TWinForm';
  Self.GroupBox1.ResumeLayout(False);
  Self.GroupBox2.ResumeLayout(False);
  Self.GroupBox3.ResumeLayout(False);
  Self.GroupBox4.ResumeLayout(False);
  Self.GroupBox5.ResumeLayout(False);
  Self.GroupBox6.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;

  FEcoSpace := TServiceDemoEcoSpace.Create;
  ReferenceHandle1.EcoSpace := FEcoSpace;

  // The line below will automatically activate the ECO Space.
  // Remove the line if you wish to activate it manually
  FEcoSpace.Active := True;

end;

{$REGION 'IUndoService functionality'}
/// <summary>
/// Using an expicit transaction can make things go fatsre, as the system
/// will create an implicit transaction for each change otherwise.
/// </summary>
procedure TWinForm.btnTransactions_Click(sender: System.Object; e: System.EventArgs);
var
  i: integer;
  TransactionElapsed,
  Elapsed: TimeSpan;
  t: DateTime;
begin
  t := DateTime.Now;
  EcoSpace.UndoService.StartTransaction;
  for i := 0 to 3000 do
    Person.Create(EcoSpace);
  EcoSpace.UndoService.CommitTransaction;
  TransactionElapsed := DateTime.Now - t;

  t := DateTime.Now;
  for i := 0 to 3000 do
    Person.Create(EcoSpace);
  Elapsed := DateTime.Now - t;

  MessageBox.Show('With Transactions: ' + TransactionElapsed.Milliseconds.ToString + 'ms' + #10#13 +
                  'No transactions: '  + Elapsed.Milliseconds.ToString + 'ms');
end;

/// <summary>
/// Clears the stack of undo-blocks
/// ClearAllUndoBlocks prevent operations to be undone.
/// </summary>
procedure TWinForm.btnCLearBlocks_Click(sender: System.Object; e: System.EventArgs);
begin
  EcoSpace.UndoService.ClearAllUndoBlocks;
end;

/// <summary>
/// Starts a new undo-block.
/// The state of the object space when starting a new undo block
/// is the state it will be reset to when undoing.
/// </summary>
procedure TWinForm.btnSetUndoPoint_Click(sender: System.Object; e: System.EventArgs);
begin
  EcoSpace.UndoService.StartUndoBlock;
end;

/// <summary>
/// Redoes an undone block
/// If there is a recently undone undoblock, undoing it can be undone (i.e. redone).
/// </summary>
procedure TWinForm.btnRedo_Click(sender: System.Object; e: System.EventArgs);
begin
  EcoSpace.UndoService.RedoLatest;
end;

/// <summary>
/// Undoes all changes in current undo-block
/// An undoblock is implicitly started at application startup, so if no new undoblocks
/// are created, all changes will be undone.
/// Note that UpdateDatabase clears all undo blocks.
/// </summary>
procedure TWinForm.btnUndo_Click(sender: System.Object; e: System.EventArgs);
begin
  EcoSpace.UndoService.UndoLatest;
end;
{$ENDREGION}

{$REGION 'FeatureWrapper'}
type
  FeatureWrapper = class
  private
    fFeature: IFeature;
  public
    constructor Create(Feature: IFeature);
    function ToString: string; override;
    property Feature: IFeature read fFeature;
  end;

// FeatureWrapper

constructor FeatureWrapper.Create(Feature: IFeature);
begin
  inherited Create;
  fFeature := Feature;
end;

function FeatureWrapper.ToString: string;
var
  OwnerAsEcoClass: IEcoClass;
begin
  OwnerAsEcoClass := Feature.Owner.EcoClassifier as IEcoClass;
  Result := System.String.Format('({0}) {1}: {2}', [Feature.FeatureType, Feature.Name, OwnerAsEcoClass.AllStructuralFeatures.GetItemByName(Feature.Name).Type_.Name])
end;
{$ENDREGION}

{$REGION 'Set properties in various ways'}
procedure TWinForm.btnSetAsObject_Click(sender: System.Object; e: System.EventArgs);
var
  MyIObject: IObject;
  feature: IFeature;
begin
  MyIObject := IObject(CurrencyManagerHandle.CurrentElement(lbxInstances));
  // The feature is wrapped in a FeatureWrapper
  feature := FeatureWrapper(lbxProperties.SelectedItem).Feature;
  MyIObject.Properties.Item[feature.Name].AsObject := tbxPropertyData.Text;
end;

procedure TWinForm.btnSetViaPerson_Click(sender: System.Object; e: System.EventArgs);
var
  MyIObject: IObject;
begin
  MyIObject := IObject(CurrencyManagerHandle.CurrentElement(lbxInstances));
  if Assigned(MyIObject) then
    Person(MyIObject.AsObject).name := tbxPropertyData.Text;
end;

procedure TWinForm.btnSetViaAssign_Click(sender: System.Object; e: System.EventArgs);
var
  MyIObject: IObject;
  feature: IFeature;
  MyIElement: IElement;
begin
  MyIObject := IObject(CurrencyManagerHandle.CurrentElement(lbxInstances));
  // The feature is wrapped in a FeatureWrapper
  feature := FeatureWrapper(lbxProperties.SelectedItem).Feature;

  MyIElement := EcoSpace.VariableFactoryService.CreateConstant(tbxPropertyData.Text);
  MyIObject.Properties.Item[feature.Name].Assign(MyIElement);
end;
{$ENDREGION}

procedure TWinForm.btnExtractValue_Click(sender: System.Object; e: System.EventArgs);
var
  MyIObject: IObject;
  feature: IFeature;
begin
  MyIObject := CurrencyManagerHandle.CurrentElement(lbxInstances) as IObject;
  if not Assigned(MyIObject) then
  begin
    MessageBox.Show('Please select an instance in the instance list (Use one of the create buttons to create an instance)');
    lbxInstances.Focus;
    Exit;
  end;
  if lbxProperties.SelectedIndex > -1 then
  begin
    // The feature is wrapped in a FeatureWrapper
    feature := FeatureWrapper(lbxProperties.SelectedItem).Feature;
    // Get the data via AsObject and get the string value
    tbxPropertyData.Text := MyIObject.Properties.Item[feature.Name].AsObject.ToString;
  end
  else
  begin
    MessageBox.Show('Please select a property in the listbox (Click "Get Properties" to fill it)');
    lbxInstances.Focus;
  end;
end;

procedure TWinForm.lbxInstances_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
begin
  //lbxProperties.Items.Clear;
end;

{$REGION 'Object creation'}
/// <summary>
/// IObjectFactoryService
/// Create an object using a reference to an IClass.
/// </summary>
procedure TWinForm.btnCreateByIClass_Click(sender: System.Object; e: System.EventArgs);
var
  EcoClassName: string;
  Classifier: IClassifier;
begin
  if Assigned(lbxClasses.SelectedItem) then
  begin
    // Get the name of the selected class
    EcoClassName := lbxClasses.SelectedItem.ToString();
    // Get the classifier from the typesystem
    Classifier := EcoSpace.TypeSystemService.TypeSystem.GetClassifierByName(EcoClassName);
    // Make sure it's an IClass (we're pretty sure it is!)
    if Classifier is IClass then
      // Create the object from the IClass
      EcoSpace.ObjectFactoryService.CreateNewObject(Classifier as IClass);
  end
  else
  begin
    MessageBox.Show('Please select a class in the listbox (Click Get Classes to fill it)');
    lbxClasses.Focus;
  end;
end;

/// <summary>
/// Create a new object from a type.
/// </summary>
procedure TWinForm.btnCreateByClassType_Click(sender: System.Object; e: System.EventArgs);
begin
  EcoSpace.ObjectFactoryService.CreateNewObject(typeof(Person));
end;

/// <summary>
/// "Normal" object creation.
/// </summary>
procedure TWinForm.btnUsingConstructor_Click(sender: System.Object; e: System.EventArgs);
begin
  Person.Create(EcoSpace);
end;

/// <summary>
/// Create a new object by the string containing the class name.
/// </summary>
procedure TWinForm.btnCreateByClassName_Click(sender: System.Object; e: System.EventArgs);
var
  EcoClassName: string;
begin
  if Assigned(lbxClasses.SelectedItem) then
  begin
    // Get the name of the selected class
    EcoClassName := lbxClasses.SelectedItem.ToString();
    // Create an instance based on that class name
    EcoSpace.ObjectFactoryService.CreateNewObject(EcoClassName);
  end
  else
  begin
    MessageBox.Show('Please select a class in the listbox (Click Get Classes to fill it)');
    lbxClasses.Focus;
  end;
end;

{$ENDREGION}

{$REGION 'Generic meta-data access'}

procedure TWinForm.btnGetClasses_Click(sender: System.Object; e: System.EventArgs);
var
  TypeSystemService: ITypeSystemService;
  i: integer;
begin
  // Get the TypeSystemService
  TypeSystemService := EcoSpace.TypeSystemService;
  // Iterate all classes and put the names in the listbox
  for i := 0 to TypeSystemService.TypeSystem.AllClasses.Count - 1 do
    lbxClasses.Items.Add(TypeSystemService.TypeSystem.AllClasses[i].Name);
end;

procedure TWinForm.btnGetProperties_Click(sender: System.Object; e: System.EventArgs);
var
  AsIObject: IObject;
  AsIClass: IClass;
  i: integer;
begin
  AsIObject := IObject(CurrencyManagerHandle.CurrentElement(lbxInstances));
  if Assigned(AsIObject) then
  begin
    AsIClass := AsIObject.UmlClass;
    for i := 0 to AsIClass.Features.Count - 1 do
    begin
      // Add the feature - wrapped in a FeatureWrapper - to the listbox
      lbxProperties.Items.Add(FeatureWrapper.Create(AsIClass.Features[i]));
    end;
  end
  else
  begin
    MessageBox.Show('Please select an instance in the instance list (Use one of the create buttons to create an instance)');
  end;
end;

{$ENDREGION}

{$REGION 'IPersistenceService'}
procedure TWinForm.Button1_Click(sender: System.Object; e: System.EventArgs);
var
  PersistenceService: IPersistenceService;
  DirtyListService: IDirtyListService;
begin
  // PersistenceService deals with persistence
  PersistenceService := EcoSpace.PersistenceService;
  // DirtyListService knows about unsaved (dirty) objects
  DirtyListService := EcoSpace.DirtyListService;
  if Assigned(PersistenceService) and Assigned(DirtyListService) and DirtyListService.HasDirtyObjects then
    PersistenceService.UpdateDatabaseWithList(DirtyListService.AllDirtyObjects);
end;

procedure TWinForm.btnUnloadList_Click(sender: System.Object; e: System.EventArgs);
var
  i: integer;
  SourceList: IList;
  UnloadObjectList: IObjectList;
begin
  UnloadObjectList := EcoSpace.VariableFactoryService.CreateUntypedObjectList(false);
  SourceList := (lbxInstances.BindingContext[lbxInstances.DataSource] as CurrencyManager).List; // GetObjectListFromDataSource(lbxInstances);

  for i := 0 to lbxInstances.SelectedIndices.Count - 1 do
    UnloadObjectList.Add(IElementProvider(SourceList[lbxInstances.SelectedIndices.Item[i]]).Element as IObject);

  EcoSpace.PersistenceService.Unload(UnloadObjectList);
end;

procedure TWinForm.btnUnloadObject_Click(sender: System.Object; e: System.EventArgs);
var
  MyIObject: IObject;
begin
  MyIObject := IObject(CurrencyManagerHandle.CurrentElement(lbxInstances));
  EcoSpace.PersistenceService.Unload(MyIObject);
end;

{$ENDREGION}

end.
